package ru.yandex.direct.internaltools.datafetchers;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.internaltools.core.annotations.enrich.EnrichFetcher;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

@EnrichFetcher(InternalToolDetailKey.STARTREK_TICKET_LINK_REPLACE)
@ParametersAreNonnullByDefault
public class StartrekTicketLinkFetcher implements InternalToolEnrichDataFetcher<String, String> {
    private static final String STARTREK_BASE_URL = "https://st.yandex-team.ru/";

    @Override
    public Map<String, String> fetch(Collection<String> tickets) {
        return StreamEx.of(tickets)
                .filter(ticket -> ticket != null && !ticket.isEmpty())
                .mapToEntry(ticket -> STARTREK_BASE_URL + ticket)
                .toMap();
    }
}
