package ru.yandex.direct.internaltools.datafetchers;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.entity.user.service.UserService;
import ru.yandex.direct.internaltools.core.annotations.enrich.EnrichFetcher;
import ru.yandex.direct.internaltools.core.container.InternalToolUserData;
import ru.yandex.direct.internaltools.core.enrich.InternalToolEnrichDataFetcher;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

/**
 * Enrich fetcher, который может быть использован с String полями с логинами пользователей.
 * При его использовании в таблице с результатами значения
 * будут заменены на улучшенное представление пользователя.
 * Реализация замены в /direct/web/src/main/resources/webapp/static/internaltools/result.jsx
 */
@EnrichFetcher(InternalToolDetailKey.LOGIN)
@ParametersAreNonnullByDefault
public class UserDataByLoginFetcher implements InternalToolEnrichDataFetcher<String, InternalToolUserData> {
    private final UserService userService;

    public UserDataByLoginFetcher(UserService userService) {
        this.userService = userService;
    }

    @Override
    public Map<String, InternalToolUserData> fetch(Collection<String> logins) {
        Collection<User> users = userService.massGetUserByLogin(logins);
        return StreamEx.of(users).mapToEntry(User::getLogin, InternalToolUserData::new).toMap();
    }
}
