package ru.yandex.direct.internaltools.tools.additionaltargetings.container;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class ClientAdditionalTargetingsInfo {
    @JsonProperty("Номер клиента")
    private Long clientId;

    @JsonProperty("Номер таргетинга")
    private Long targetingId;

    @JsonProperty("Таргетинг")
    @Enrich(InternalToolDetailKey.JSON_PRETTIFY)
    private String targeting;

    @JsonProperty("Комментарий")
    private String comment;

    public ClientAdditionalTargetingsInfo(Long clientId, Long targetingId, String targeting, String comment) {
        this.clientId = clientId;
        this.targetingId = targetingId;
        this.targeting = targeting;
        this.comment = comment;
    }

    public Long getClientId() {
        return clientId;
    }

    public Long getTargetingId() {
        return targetingId;
    }

    public String getTargeting() {
        return targeting;
    }

    public String getComment() {
        return comment;
    }
}
