package ru.yandex.direct.internaltools.tools.additionaltargetings.model

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import ru.yandex.direct.internaltools.core.annotations.input.Input
import ru.yandex.direct.internaltools.core.annotations.input.TextArea
import ru.yandex.direct.internaltools.core.container.InternalToolParameter
import ru.yandex.direct.internaltools.utils.ToolParameterUtils

@JsonIgnoreProperties(ignoreUnknown = true)
class CampAdditionalTargetingsAddParameters : InternalToolParameter() {
    @TextArea
    @Input(
        label = "Кампании",
        description = "Cid'ы кампаний (в БК это ExportID) должны быть отделены запятыми и/или пробелами"
    )
    lateinit var campaignIds: String

    @TextArea
    @Input(
        label = "Таргетинг для добавления",
        description = """формат: {"and": [{"or": [{"keyword": 1,"operation": 2,"value": "val"}] }] }<br>""" +
            "Справочники значений для <a href='https://a.yandex-team.ru/arc/trunk/arcadia/adv/direct/proto/expression/keywords.proto'>keyword</a>" +
            " и <a href='https://a.yandex-team.ru/arc/trunk/arcadia/adv/direct/proto/expression/operations.proto'>operation</a>",
        required = false
    )
    var targeting: String? = null

    @TextArea
    @Input(
        label = "Комментарий для добавления",
        required = false
    )
    var comment: String? = null

    fun parseDistinctCampaignIds(): Set<Long> = ToolParameterUtils.getLongIdsFromString(campaignIds)
}
