package ru.yandex.direct.internaltools.tools.additionaltargetings.model

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import ru.yandex.direct.internaltools.core.annotations.input.Input
import ru.yandex.direct.internaltools.core.annotations.input.TextArea
import ru.yandex.direct.internaltools.core.container.InternalToolParameter
import ru.yandex.direct.internaltools.utils.ToolParameterUtils.getLongIdsFromString

@JsonIgnoreProperties(ignoreUnknown = true)
class CampAdditionalTargetingsDeleteParameters : InternalToolParameter() {
    @TextArea
    @Input(
        label = "Кампании",
        description = "Cid'ы кампаний (в БК это ExportID) должны быть отделены запятыми и/или пробелами",
        required = false
    )
    var campaignIds: String? = null

    @TextArea
    @Input(
        label = "Таргетинги",
        description = "id должны быть отделены запятыми и/или пробелами",
        required = false
    )
    var targetingIds: String? = null

    fun parseDistinctCampaignIds(): Set<Long> = getLongIdsFromString(campaignIds)

    fun parseDistinctTargetingIds(): Set<Long> = getLongIdsFromString(targetingIds)
}
