package ru.yandex.direct.internaltools.tools.additionaltargetings.model

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import ru.yandex.direct.internaltools.core.annotations.input.Input
import ru.yandex.direct.internaltools.core.annotations.input.TextArea
import ru.yandex.direct.internaltools.core.container.InternalToolParameter
import ru.yandex.direct.internaltools.utils.ToolParameterUtils.getLongIdsFromString

@JsonIgnoreProperties(ignoreUnknown = true)
class ClientAdditionalTargetingsDeleteParameters : InternalToolParameter() {
    @TextArea
    @Input(
        label = "Клиенты",
        description = "Список ClientID, отделенных запятыми и/или пробелами",
        required = false
    )
    var clientIds: String? = null

    @TextArea
    @Input(
        label = "Таргетинги",
        description = "id должны быть отделены запятыми и/или пробелами",
        required = false
    )
    var targetingIds: String? = null

    fun parseDistinctClientIds(): Set<Long> = getLongIdsFromString(clientIds)

    fun parseDistinctTargetingIds(): Set<Long> = getLongIdsFromString(targetingIds)
}
