package ru.yandex.direct.internaltools.tools.additionaltargetings.validation

import com.google.protobuf.InvalidProtocolBufferException
import com.google.protobuf.util.JsonFormat
import ru.yandex.adv.direct.expression2.TargetingExpression
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.dbutil.sharding.ShardKey
import ru.yandex.direct.internaltools.utils.ToolParameterUtils.getLongIdsFromString

object AdditionalTargetingsPredicates {
    fun areCidsExists(shardHelper: ShardHelper) = { cids: String? ->
        val listCids = getLongIdsFromString(cids!!)
        shardHelper
            .groupByShard(listCids, ShardKey.CID)
            .stream()
            .mapKeyValue { _, v -> v.size }
            .sum() == listCids.count()
    }

    fun areClientIdsExists(shardHelper: ShardHelper) = { ids: String? ->
        val listIds = getLongIdsFromString(ids!!)
        shardHelper
            .groupByShard(listIds, ShardKey.CLIENT_ID)
            .stream()
            .mapKeyValue { _, v -> v.size }
            .sum() == listIds.count()
    }

    fun isJsonCorrect() = { json: String? ->
        try {
            val builder = TargetingExpression.newBuilder()
            JsonFormat.parser().merge(json, builder)
            val obj = builder.build()
            obj.andList.isNotEmpty() && obj.andList.all {
                it.orList.isNotEmpty()
                    && it.orList.all { atom -> atom.hasKeyword() && atom.hasOperation() && atom.hasValue() }
            }
        } catch (e: InvalidProtocolBufferException) {
            false
        }
    }
}
