package ru.yandex.direct.internaltools.tools.adult;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAllowedOnAdultContent;
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository;
import ru.yandex.direct.core.entity.campaign.service.CampaignOperationService;
import ru.yandex.direct.core.entity.campaign.service.CampaignOptions;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.model.UidAndClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.adult.model.AdultContentAllowedParameter;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.result.MassResult;

@Tool(
        name = "Разрешить рекламироваться на взрослом контенте",
        label = "on_adult_content",
        description = "Разрешить или запретить рекламироваться на взрослом контенте для РК",
        consumes = AdultContentAllowedParameter.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.UPDATE)
@Category(InternalToolCategory.CPM)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class AdultContentAllowedTool implements BaseInternalTool<AdultContentAllowedParameter> {

    private final CampaignOperationService campaignOperationService;
    private final CampaignTypedRepository campaignTypedRepository;
    private final ShardHelper shardHelper;

    @Autowired
    public AdultContentAllowedTool(
            CampaignOperationService campaignOperationService,
            CampaignTypedRepository campaignTypedRepository,
            ShardHelper shardHelper
    ) {
        this.campaignOperationService = campaignOperationService;
        this.campaignTypedRepository = campaignTypedRepository;
        this.shardHelper = shardHelper;
    }

    @Override
    public InternalToolResult process(AdultContentAllowedParameter parameter) {
        int shard = shardHelper.getShardByCampaignId(parameter.getCampaignId());
        List<? extends BaseCampaign> typedCampaigns =
                campaignTypedRepository.getTypedCampaigns(shard, List.of(parameter.getCampaignId()));
        CampaignWithAllowedOnAdultContent camp = (CampaignWithAllowedOnAdultContent) typedCampaigns.get(0);
        List<ModelChanges<CampaignWithAllowedOnAdultContent>> modelChanges = List.of(
                new ModelChanges<>(camp.getId(), CampaignWithAllowedOnAdultContent.class)
                        .process(parameter.isEnable(), CampaignWithAllowedOnAdultContent.IS_ALLOWED_ON_ADULT_CONTENT)
        );
        var options = new CampaignOptions();
        var updateOperation = campaignOperationService.createRestrictedCampaignUpdateOperation(
                modelChanges,
                parameter.getOperator().getUid(),
                // uid и ClientID субъекта берём от самой кампании, т.к. это инструмент для супера и суперам так можно
                UidAndClientId.of(camp.getUid(), ClientId.fromLong(camp.getClientId())),
                options
        );
        MassResult<Long> updateResult = updateOperation.apply();
        if (updateResult.isSuccessful() && updateResult.getErrorCount() == 0) {
            return new InternalToolResult("OK: " + parameter.getCampaignId());
        }
        return new InternalToolResult("NOT OK: " + updateResult.getValidationResult().flattenErrors().toString());
    }
}
