package ru.yandex.direct.internaltools.tools.agency.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNonnullByDefault
public class AgencyDealNotificationEmail extends InternalToolParameter {

    @Text
    @Input(label = "Логин агентства", required = true)
    private String login;

    @Text
    @Input(label = "Адрес электронной почты для уведомлений о сделках", required = true)
    private String email;

    public String getLogin() {
        return login;
    }

    public AgencyDealNotificationEmail withEmail(String email) {
        this.email = email;
        return this;
    }

    public String getEmail() {
        return email;
    }

    public AgencyDealNotificationEmail withLogin(String login) {
        this.login = login;
        return this;
    }
}
