package ru.yandex.direct.internaltools.tools.aggregatedstatuses.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.core.aggregatedstatuses.repository.model.RecalculationDepthEnum;
import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.ShardSelect;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class RecalculateCampaignsStatusJobParameters extends InternalToolParameter {
    public static final String ACTION_LABEL = "Действие";
    public static final String RECALCULATION_DEPTH_LABEL = "Уровень объектов для пересчета";
    public static final String ALL_SHARDS_LABEL = "Для всех шардов";
    public static final String SHARD_LABEL = "Шард";

    @Input(label = ACTION_LABEL)
    private Action action;

    public enum Action {
        NEW_START("Начать заново пересчет статусов"),
        CONTINUE("Продолжить пересчет статусов"),
        PAUSE("Остановить пересчет статусов");

        private final String description;

        Action(String description) {
            this.description = description;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }
    }

    @Input(label = RECALCULATION_DEPTH_LABEL)
    private RecalculationDepth recalculationDepth;

    public enum RecalculationDepth {
        ALL("Пересчет всех сущностей", RecalculationDepthEnum.ALL),
        CAMPAIGNS("Пересчет только кампаний", RecalculationDepthEnum.CAMPAIGNS),
        ADGROUPS("Пересчет только подобъектов кампаний (адгрупп)", RecalculationDepthEnum.ADGROUPS),
        ADGROUPSUBJECTS("Пересчет только подобъектов адгрупп (баннеров, ключевых фраз, ретаргетингов)",
                RecalculationDepthEnum.ADGROUPSUBJECTS);

        private final String description;
        private final RecalculationDepthEnum value;

        RecalculationDepth(String description, RecalculationDepthEnum value) {
            this.description = description;
            this.value = value;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }

        @JsonIgnore
        public RecalculationDepthEnum getValue() {
            return value;
        }
    }

    @Input(label = ALL_SHARDS_LABEL, description = "Если опция включена, то значение поля \"" + SHARD_LABEL
            + "\" игнорируется")
    @CheckBox(checked = false)
    private boolean allShards;

    @Input(label = SHARD_LABEL, required = false)
    @ShardSelect
    private Integer shard;

    public Action getAction() {
        return action;
    }

    public RecalculateCampaignsStatusJobParameters withAction(Action action) {
        this.action = action;
        return this;
    }

    public RecalculationDepth getRecalculationDepth() {
        return recalculationDepth;
    }

    public RecalculateCampaignsStatusJobParameters withRecalculationDepth(RecalculationDepth recalculationDepth) {
        this.recalculationDepth = recalculationDepth;
        return this;
    }

    public boolean isAllShards() {
        return allShards;
    }

    public RecalculateCampaignsStatusJobParameters withAllShards(boolean allShards) {
        this.allShards = allShards;
        return this;
    }

    public Integer getShard() {
        return shard;
    }

    public RecalculateCampaignsStatusJobParameters withShard(Integer shard) {
        this.shard = shard;
        return this;
    }
}
