package ru.yandex.direct.internaltools.tools.asap;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.client.model.ClientFlags;

/**
 * Utils класс для {@link SetAsSoonAsPossibleTool}.
 */
class SetAsSoonAsPossibleToolUtils {

    public static final String AS_SOON_AS_POSSIBLE_FLAG_VALUE = ClientFlags.AS_SOON_AS_POSSIBLE.getTypedValue();

    /**
     * Добавляет или удаляет флаг AS_SOON_AS_POSSIBLE из набора флагов.
     *
     * @param clientFlags   текущий набор флагов
     * @param setAsap       true - если нужно добавить флаг, false - если удалить
     * @return новый набор флагов
     */
    static Set<String> buildNewClientFlags(@Nullable Set<String> clientFlags, boolean setAsap) {
        if (clientFlags == null) {
            return setAsap ? Set.of(AS_SOON_AS_POSSIBLE_FLAG_VALUE) : null;
        }

        Set<String> updatedClientFlags = new HashSet<>(clientFlags);
        if (setAsap) {
            updatedClientFlags.add(AS_SOON_AS_POSSIBLE_FLAG_VALUE);
        } else {
            updatedClientFlags.remove(AS_SOON_AS_POSSIBLE_FLAG_VALUE);
        }

        return updatedClientFlags;
    }
}
