package ru.yandex.direct.internaltools.tools.asap.model;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class SetAsSoonAsPossibleToolParams extends InternalToolParameter {

    public static final String LOGINS_TEXT_FIELD_NAME = "logins_text";
    public static final String LOGINS_FIELD_NAME = "logins";
    public static final String ASAP_FIELD_NAME = "asap";

    @Text
    @Input(label = "Логины пользователей", required = false)
    private String loginsToSetAsap;

    @CheckBox(checked = true)
    @Input(label = "Включить приоритетную отправку кампаний")
    private Boolean setAsap;

    public String getLoginsToSetAsap() {
        return loginsToSetAsap;
    }

    public void setLoginsToSetAsap(String loginsToSetAsap) {
        this.loginsToSetAsap = loginsToSetAsap;
    }

    public SetAsSoonAsPossibleToolParams withLoginsToSetAsap(String loginsToSetAsap) {
        setLoginsToSetAsap(loginsToSetAsap);
        return this;
    }

    public Boolean getSetAsap() {
        return setAsap;
    }

    public void setSetAsap(Boolean setAsap) {
        this.setAsap = setAsap;
    }

    public SetAsSoonAsPossibleToolParams withSetAsap(Boolean setAsap) {
        setSetAsap(setAsap);
        return this;
    }
}
