package ru.yandex.direct.internaltools.tools.balanceaggrmigration.container;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class BalanceAggregateMigrationParameters extends InternalToolParameter {

    @TextArea
    @Input(label = "Логины клиентов:",
            description = "логины клиентов должны быть отделены друг от друга запятой или любым whitespace символом",
            required = false
    )
    private String logins;


    @Input(label = "миграция / откат",
            description = "выбор направления миграции для указанных клиентов",
            required = false)
    private MigrationTypeReportValue type;

    @Input(label = "включить рубильник")
    @CheckBox(checked = false)
    private Boolean enableMigration;

    public String getLogins() {
        return logins;
    }

    public BalanceAggregateMigrationParameters withLogins(String logins) {
        this.logins = logins;
        return this;
    }

    public MigrationTypeReportValue getType() {
        return type;
    }

    public BalanceAggregateMigrationParameters withType(MigrationTypeReportValue type) {
        this.type = type;
        return this;
    }

    public Boolean getEnableMigration() {
        return enableMigration;
    }

    public BalanceAggregateMigrationParameters withEnableMigration(Boolean enableMigration) {
        this.enableMigration = enableMigration;
        return this;
    }
}
