package ru.yandex.direct.internaltools.tools.banner;

import java.util.List;
import java.util.Map;

import one.util.streamex.EntryStream;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.internaltools.tools.banner.model.IntToolBannerTurboGallery;

public class IntToolBannerConverter {

    static List<IntToolBannerTurboGallery> toIntToolBannerTurboGalleries(Map<Long, String> bannerTurboGalleries,
                                                                         Map<Long, ClientId> clientIdByBannerIds) {
        return EntryStream.of(bannerTurboGalleries)
                .mapKeyValue(IntToolBannerConverter::toIntToolBannerTurboGallery)
                .peek(tool -> tool.setClientId(clientIdByBannerIds.get(tool.getBannerId()).asLong()))
                .toList();
    }

    private static IntToolBannerTurboGallery toIntToolBannerTurboGallery(Long bannerId, String turboGalleryHref) {
        IntToolBannerTurboGallery intToolBannerTurboGallery = new IntToolBannerTurboGallery();
        intToolBannerTurboGallery.setBannerId(bannerId);
        intToolBannerTurboGallery.setTurboGalleryHref(turboGalleryHref);
        return intToolBannerTurboGallery;
    }
}
