package ru.yandex.direct.internaltools.tools.banner;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.domain.AggregatorDomainsUtils;
import ru.yandex.direct.core.entity.domain.model.BannerUpdateAggeregatorDomainParams;
import ru.yandex.direct.dbqueue.repository.DbQueueRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.banner.model.UpdateAggregatorDomainsParameters;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.constraint.CommonConstraints;
import ru.yandex.direct.validation.constraint.StringConstraints;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.dbqueue.DbQueueJobTypes.UPDATE_AGGREGATOR_DOMAINS;

@Tool(
        name = "Пересчитать и переотправить в БК идентификатоды для доменов-агрегаторов",
        label = "update_aggregator_domains",
        description = "Находит все баннеры для переданного домена и пересчитывает aggregator_domains. " +
                "Затем отправляет их в бк через ленивую очередь",
        consumes = UpdateAggregatorDomainsParameters.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.SET)
@Category(InternalToolCategory.BS_EXPORT)
@AccessGroup({InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.SUPER})
@ParametersAreNonnullByDefault
public class UpdateAggregatorDomainsTool implements BaseInternalTool<UpdateAggregatorDomainsParameters> {
    private final DbQueueRepository dbQueueRepository;
    private final ShardHelper shardHelper;

    public UpdateAggregatorDomainsTool(DbQueueRepository dbQueueRepository, ShardHelper shardHelper) {
        this.dbQueueRepository = dbQueueRepository;
        this.shardHelper = shardHelper;
    }

    @Override
    public ValidationResult<UpdateAggregatorDomainsParameters, Defect> validate(UpdateAggregatorDomainsParameters parameters) {
        ItemValidationBuilder<UpdateAggregatorDomainsParameters, Defect> v = ItemValidationBuilder.of(parameters);
        v.item(parameters.getDomain(), "domain")
                .check(StringConstraints.notEmpty2())
                .check(CommonConstraints.inSet(AggregatorDomainsUtils.registeredDomans()));
        return v.getResult();
    }

    @Override
    public InternalToolResult process(UpdateAggregatorDomainsParameters updateAggregatorDomainsParameters) {
        var params = new BannerUpdateAggeregatorDomainParams();
        params.setDomain(updateAggregatorDomainsParameters.getDomain());
        shardHelper.forEachShard(shard -> {
            dbQueueRepository.insertJob(shard, UPDATE_AGGREGATOR_DOMAINS, ClientId.fromLong(0L), 0L, params);
        });
        return new InternalToolResult();
    }
}
