package ru.yandex.direct.internaltools.tools.banner.model;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class BannerTurboAppUpdateParams extends InternalToolParameter {

    public enum Action {
        ADD_TURBO_APP("Добавить турбо-апп"),
        DELETE_TURBO_APP("Удалить турбо-апп"),
        DISABLE_TURBO_APPS("Выключить опцию на кампании");

        private final String description;

        Action(String description) {
            this.description = description;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }
    }

    @Select
    @Input(label = "Действие")
    private Action action;

    @NumericId
    @Input(label = "ClientId", required = false)
    private Long clientId;

    @TextArea
    @Input(label = "ID баннеров, через запятую", required = false)
    private String bannerIds;

    @TextArea
    @Input(label = "ID кампаний, через запятую", required = false)
    private String campaignIds;

    @NumericId
    @Input(label = "ID турбо-аппа", required = false)
    private Long turboAppId;

    @TextArea
    @Input(label = "Content турбо-аппа", required = false)
    private String content;

    @TextArea
    @Input(label = "MetaContent баннера", required = false)
    private String metaContent;

    public Action getAction() {
        return action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public String getBannerIds() {
        return bannerIds;
    }

    public void setBannerIds(String bannerIds) {
        this.bannerIds = bannerIds;
    }

    public String getCampaignIds() {
        return campaignIds;
    }

    public void setCampaignIds(String campaignIds) {
        this.campaignIds = campaignIds;
    }

    public Long getTurboAppId() {
        return turboAppId;
    }

    public void setTurboAppId(Long turboAppId) {
        this.turboAppId = turboAppId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getMetaContent() {
        return metaContent;
    }

    public void setMetaContent(String metaContent) {
        this.metaContent = metaContent;
    }
}
