package ru.yandex.direct.internaltools.tools.banner.model;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.Text;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class BannerTurboGalleryUpdateParams extends InternalToolParameter {

    public enum Action {
        UPDATE_TURBO_GALLERY_HREF("Добавить или обновить ссылку"),
        DELETE_TURBO_GALLERY_HREF("Удалить ссылку");

        private final String description;

        Action(String description) {
            this.description = description;
        }

        @JsonValue
        public String getDescription() {
            return description;
        }
    }

    @Select
    @Input(label = "Действие")
    private Action action;

    @NumericId
    @Input(label = "ID баннера")
    private Long bannerId;

    @Text
    @Input(label = "Ссылка на турбо-галерею", required = false)
    private String turboGalleryHref;

    public Action getAction() {
        return action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public void setBannerId(Long bannerId) {
        this.bannerId = bannerId;
    }

    public String getTurboGalleryHref() {
        return turboGalleryHref;
    }

    public void setTurboGalleryHref(String turboGalleryHref) {
        this.turboGalleryHref = turboGalleryHref;
    }
}
