package ru.yandex.direct.internaltools.tools.banner.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class IntToolBannerTurboApp {

    @JsonProperty("clientId")
    private Long clientId;

    @JsonProperty("bannerId")
    private Long bannerId;

    @JsonProperty("turboAppId")
    private Long turboAppId;

    @JsonProperty("content")
    private String content;

    @JsonProperty("metaContent")
    private String metaContent;

    @JsonProperty("Тип баннера")
    private String bannerType;

    public Long getClientId() {
        return clientId;
    }

    public IntToolBannerTurboApp withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public IntToolBannerTurboApp withBannerId(Long bannerId) {
        this.bannerId = bannerId;
        return this;
    }

    public Long getTurboAppId() {
        return turboAppId;
    }

    public IntToolBannerTurboApp withTurboAppId(Long turboAppId) {
        this.turboAppId = turboAppId;
        return this;
    }

    public String getContent() {
        return content;
    }

    public IntToolBannerTurboApp withContent(String content) {
        this.content = content;
        return this;
    }

    public String getMetaContent() {
        return metaContent;
    }

    public IntToolBannerTurboApp withMetaContent(String metaContent) {
        this.metaContent = metaContent;
        return this;
    }

    public String getBannerType() {
        return bannerType;
    }

    public IntToolBannerTurboApp withBannerType(String bannerType) {
        this.bannerType = bannerType;
        return this;
    }
}
