package ru.yandex.direct.internaltools.tools.bidmodifiers.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.NumericId;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
public class BidModifiersSetParameters extends InternalToolParameter {

    @NumericId
    @Input(label = "Номер кампании")
    private Long campaignId;

    @NumericId
    @Input(label = "Номер группы", required = false)
    private Long adGroupId;

    @TextArea(rows = 25)
    @Input(label = "JSON код устанавливаемых корректировок")
    private String complexBidModifierJson;

    public Long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public String getComplexBidModifierJson() {
        return complexBidModifierJson;
    }

    public void setComplexBidModifierJson(String complexBidModifierJson) {
        this.complexBidModifierJson = complexBidModifierJson;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }
}
