package ru.yandex.direct.internaltools.tools.brandlift.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.SurveyStatus;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;


@ParametersAreNonnullByDefault
public class UpdateBrandLiftStatusesToolParameter extends InternalToolParameter {

    @TextArea
    @Input(label = "id компаний",
            description = "cid(campaign_id) должны быть отделены друг от друга запятой или любым whitespace символом")
    private String cids;

    @Input(label = "Новый статус",
            description = "Должно быть UNFEASIBLE, если причины остановки не пусты.")
    private SurveyStatus status;

    @Input(label = "Причины остановки",
            description = "Причины остновки должны быть отделены друг от друга запятой." +
                    " Валидные причины: LOW_BUDGET, LOW_TOTAL_BUDGET, LOW_DAILY_BUDGET, LOW_REACH," +
                    "Нельзя использовать LOW_BUDGET вместе с LOW_TOTAL_BUDGET или LOW_DAILY_BUDGET",
            required = false)
    @Nullable
    private String stopReasons;

    @Input(label = "Что делать с причинами остановки",
    description = "DO_NOTHING - не менять, ADD_STOP_REASONS - добавить к уже имеющимся, REPLACE_STOP_REASONS - перезаписать")
    private Actions actions;

    public String getCids() {
        return cids;
    }

    public void setCids(String cids) {
        this.cids = cids;
    }

    public SurveyStatus getStatus() {
        return status;
    }

    public void setStatus(SurveyStatus status) {
        this.status = status;
    }

    public String getStopReasons() {
        return stopReasons;
    }

    public void setStopReasons(String stopReasons) {
        this.stopReasons = stopReasons;
    }

    public Actions getActions() {
        return actions;
    }

    public void setActions(Actions actions) {
        this.actions = actions;
    }

    public enum Actions {
        DO_NOTHING,
        ADD_STOP_REASONS,
        REPLACE_STOP_REASONS
    }
}
