package ru.yandex.direct.internaltools.tools.bs.export.queue;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.bs.export.queue.service.FullExportQueueService;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.bs.export.queue.model.ManageCampaignsFullExportQueueParameters;

@Tool(
        name = "Полная перепосылка кампаний в БК через LogBroker",
        label = "add_cids_to_full_lb_export_queue",
        description = "Выставляет флаг \"требуется полная переотправка\" для списка кампаний.\n"
                + "При необходимости кампания добавляется в очередь экспорта в БК.\n"
                + "\n"
                + "В результате кампания будет отправлена целиком только через LogBroker (без отправки в SOAP).\n"
                + "\n"
                + ManageCampaignsFullExportQueueTool.PARAM_DESCRIPTION,
        consumes = ManageCampaignsFullExportQueueParameters.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.ADD)
@Category(InternalToolCategory.BS_EXPORT)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class AddCampaignsToFullExportQueueTool extends ManageCampaignsFullExportQueueTool {
    @Autowired
    public AddCampaignsToFullExportQueueTool(FullExportQueueService fullExportQueueService) {
        super(fullExportQueueService::addCampaignsToFullExportQueue);
    }
}
