package ru.yandex.direct.internaltools.tools.bs.export.queue;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.bs.export.BsExportParametersService;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.bs.export.queue.model.BsExportBalancerMode;
import ru.yandex.direct.internaltools.tools.bs.export.queue.model.BsExportWorkersNumManualBalancingParameter;

@Tool(
        name = BsExportWorkersNumManualBalancingTool.TOOL_NAME,
        label = "bsexport_workers_num_balancing_mode",
        description = "Инструмент для выбора режима управления количеством воркеров экспорта в БК",
        consumes = BsExportWorkersNumManualBalancingParameter.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.SET)
@Category(InternalToolCategory.BS_EXPORT)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class BsExportWorkersNumManualBalancingTool implements BaseInternalTool<BsExportWorkersNumManualBalancingParameter> {
    public static final String MANUAL_CONTROL_MESSAGE = "Включено ручное управление";
    public static final String AUTO_CONTROL_MESSAGE = "Включен автоматический расчёт";

    public static final String TOOL_NAME = "Выбор способа управления количеством воркеров экспорта в БК";
    private static final String CURRENT_MODE = "Текущее состояние: ";
    private final BsExportParametersService service;

    @Autowired
    public BsExportWorkersNumManualBalancingTool(BsExportParametersService service) {
        this.service = service;
    }

    @Override
    public InternalToolResult process(BsExportWorkersNumManualBalancingParameter parameter) {
        if (BsExportBalancerMode.MANUAL.equals(parameter.getMode())) {
            service.enableManualControllingMode();
            return new InternalToolResult().withMessage(MANUAL_CONTROL_MESSAGE);
        } else if (BsExportBalancerMode.AUTO.equals(parameter.getMode())) {
            service.disableManualControllingMode();
            return new InternalToolResult().withMessage(AUTO_CONTROL_MESSAGE);
        } else {
            return processWithoutInput();
        }
    }

    @Override
    public InternalToolResult processWithoutInput() {
        if (service.isManualMode()) {
            return new InternalToolResult().withMessage(CURRENT_MODE + MANUAL_CONTROL_MESSAGE);
        } else {
            return new InternalToolResult().withMessage(CURRENT_MODE + AUTO_CONTROL_MESSAGE);
        }
    }
}
