package ru.yandex.direct.internaltools.tools.bs.export.queue;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.bs.export.BsExportParametersService;
import ru.yandex.direct.core.entity.bs.export.model.WorkerType;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.bs.export.queue.model.ManageBsExportWorkersNumParameters;

@Tool(
        name = ManageBsExportWorkersNumTool.TOOL_NAME + "full_lb_export",
        label = "set_bsexport_full_lb_export_workers_num",
        description = ManageBsExportFullLbExportWorkersNumTool.TOOL_DESCRIPTION_PART_MAIN + "full_lb_export",
        consumes = ManageBsExportWorkersNumParameters.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.SET)
@Category(InternalToolCategory.BS_EXPORT)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class ManageBsExportFullLbExportWorkersNumTool extends ManageBsExportWorkersNumTool {
    @Override
    boolean allowedToManageWorkersNum() {
        return true;
    }

    @Autowired
    public ManageBsExportFullLbExportWorkersNumTool(BsExportParametersService service) {
        super(service, WorkerType.FULL_LB_EXPORT);
    }
}
