package ru.yandex.direct.internaltools.tools.bs.export.queue;

import java.util.Collection;
import java.util.Set;
import java.util.function.ToIntFunction;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.tools.bs.export.queue.model.ManageCampaignsFullExportQueueParameters;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.internaltools.utils.ToolParameterUtils.getLongIdsFromString;
import static ru.yandex.direct.internaltools.utils.ToolParameterUtils.isStringWithValidLongIds;

@ParametersAreNonnullByDefault
abstract class ManageCampaignsFullExportQueueTool implements BaseInternalTool<ManageCampaignsFullExportQueueParameters> {
    static final String RESULT_TEMPLATE = "Изменено %d записей в очереди";
    static final String PARAM_DESCRIPTION = "Принимает директовские номера кампаний (cid, в БК это ExportID)"
            + " разделенные пробельными символами или запятыми.";

    private final ToIntFunction<Collection<Long>> manageMethod;

    ManageCampaignsFullExportQueueTool(ToIntFunction<Collection<Long>> manageMethod) {
        this.manageMethod = manageMethod;
    }

    @Override
    public InternalToolResult process(ManageCampaignsFullExportQueueParameters parameters) {
        Set<Long> campaignIds = getLongIdsFromString(parameters.getCampaignIds());
        int updated = manageMethod.applyAsInt(campaignIds);
        return new InternalToolResult().withMessage(String.format(RESULT_TEMPLATE, updated));
    }

    static ValidationResult<ManageCampaignsFullExportQueueParameters, Defect> validateParameters(
            ManageCampaignsFullExportQueueParameters parameters) {
        ItemValidationBuilder<ManageCampaignsFullExportQueueParameters, Defect> validationBuilder =
                ItemValidationBuilder.of(parameters);

        validationBuilder
                .item(parameters.getCampaignIds(), "campaignIds")
                .check(isStringWithValidLongIds(1));
        return validationBuilder.getResult();
    }

    @Override
    public ValidationResult<ManageCampaignsFullExportQueueParameters, Defect> validate(
            ManageCampaignsFullExportQueueParameters parameters) {
        return validateParameters(parameters);
    }
}
