package ru.yandex.direct.internaltools.tools.bs.export.queue;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.bs.export.queue.service.FullExportQueueService;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.bs.export.queue.model.ManageCampaignsFullExportQueueParameters;

@Tool(
        name = "Снятие флага \"полной перепосылки в БК через LogBroker\"",
        label = "remove_cids_from_full_lb_export_queue",
        description = "Снимает флаг \"требуется полная переотправка\" для списка кампаний в очереди экспорта в БК.\n"
                + "\n"
                + ManageCampaignsFullExportQueueTool.PARAM_DESCRIPTION,
        consumes = ManageCampaignsFullExportQueueParameters.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.DELETE)
@Category(InternalToolCategory.BS_EXPORT)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class RemoveCampaignsFromFullExportQueueTool extends ManageCampaignsFullExportQueueTool {
    @Autowired
    public RemoveCampaignsFromFullExportQueueTool(FullExportQueueService fullExportQueueService) {
        super(fullExportQueueService::removeCampaignsFromFullExportQueue);
    }
}
