package ru.yandex.direct.internaltools.tools.bs.export.queue.model;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.YesNo;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Number;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class FullExportParameters extends InternalToolParameter {
    public static final String MAX_CAMPAIGNS_IN_QUEUE_FIELD_NAME = "maxCampaignsInQueue";
    public static final String MAX_CHUNK_PER_WORKER_FIELD_NAME = "maxChunkPerWorker";
    public static final String MAX_CHUNK_PER_ITERATION_FIELD_NAME = "maxChunkPerIteration";
    public static final String ALLOW_ROLLING_WORK_FIELD_NAME = "allowRollingWork";


    @Input(label = MAX_CAMPAIGNS_IN_QUEUE_FIELD_NAME,
            description = "Максимальное количество кампаний в очереди ре-экспорта в каждом из шардов",
            required = false)
    @Number
    private Long maxCampaignsInQueue;

    @Input(label = MAX_CHUNK_PER_WORKER_FIELD_NAME,
            description = "Ограничение на количество кампаний в очереди ре-экспорта в расчете на один воркер",
            required = false)
    @Number
    private Long maxChunkPerWorker;

    @Input(label = MAX_CHUNK_PER_ITERATION_FIELD_NAME,
            description = "Ограничение на количество кампаний, добавляемых мастер-процессом в очередь ре-экспорта за один раз",
            required = false)
    @Number
    private Long maxChunkPerIteration;

    @Input(label = ALLOW_ROLLING_WORK_FIELD_NAME, description = "Начинать работу с начала после завершения?", required = false)
    private YesNo allowRollingWork;

    @Nullable
    public Long getMaxCampaignsInQueue() {
        return maxCampaignsInQueue;
    }

    @Nullable
    public Long getMaxChunkPerWorker() {
        return maxChunkPerWorker;
    }

    @Nullable
    public Long getMaxChunkPerIteration() {
        return maxChunkPerIteration;
    }

    @Nullable
    public YesNo getAllowRollingWork() {
        return allowRollingWork;
    }
}
