package ru.yandex.direct.internaltools.tools.bs.export.queue.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.bs.export.BsExportParametersService;
import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Number;
import ru.yandex.direct.internaltools.core.annotations.input.ShardSelect;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.bs.export.queue.container.ShardAndWorkersNumInfo;

@ParametersAreNonnullByDefault
public class ManageBsExportWorkersNumParameters extends InternalToolParameter {
    @Input(label = "Для всех шардов", description = "Если опция  включена, то значение поля " +
            ShardAndWorkersNumInfo.SHARD_INFO + " игнорируется")
    @CheckBox(checked = false)
    private boolean allShards;

    @Input(label = ShardAndWorkersNumInfo.SHARD_INFO)
    @ShardSelect
    private int shard;

    @Input(label = ShardAndWorkersNumInfo.WORKERS_NUM_INFO)
    @Number(defaultValue = BsExportParametersService.DEFAULT_WORKERS_NUM)
    private Long workersNum;

    public boolean isAllShards() {
        return allShards;
    }

    public void setAllShards(boolean allShards) {
        this.allShards = allShards;
    }

    public int getShard() {
        return shard;
    }

    public void setShard(int shard) {
        this.shard = shard;
    }

    public Long getWorkersNum() {
        return workersNum;
    }

    public void setWorkersNum(Long workersNum) {
        this.workersNum = workersNum;
    }
}
