package ru.yandex.direct.internaltools.tools.bsresyncqueue;

import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.bs.resync.queue.service.BsResyncService;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.bsresyncqueue.container.ViewResyncQueueInfo;
import ru.yandex.direct.internaltools.utils.model.CampaignIdParameter;
import ru.yandex.direct.utils.FunctionalUtils;

@Tool(
        name = "Просмотр очереди ленивой переотправки в БК",
        label = "view_bs_resync_queue",
        description = "Покажет все записи (по указанной кампании), имеющиеся в очереди ленивой переотправки в БК",
        consumes = CampaignIdParameter.class,
        type = InternalToolType.REPORT
)
@Action(InternalToolAction.SHOW)
@Category(InternalToolCategory.BS_EXPORT)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.SUPERREADER})
@ParametersAreNonnullByDefault
public class ViewBsResyncQueueTool extends MassInternalTool<CampaignIdParameter, ViewResyncQueueInfo> {

    private final BsResyncService bsResyncService;

    @Autowired
    public ViewBsResyncQueueTool(BsResyncService bsResyncService) {
        this.bsResyncService = bsResyncService;
    }

    @Override
    public List<ViewResyncQueueInfo> getMassData(CampaignIdParameter parameters) {
        return FunctionalUtils
                .mapList(bsResyncService
                                .getBsResyncItemsByCampaignIds(Collections.singletonList(parameters.getCampaignId())),
                        bsResyncQueueInfo -> new ViewResyncQueueInfo()
                                .withCampaignId(bsResyncQueueInfo.getCampaignId())
                                .withAdGroupId(bsResyncQueueInfo.getAdgroupId())
                                .withBannerId(bsResyncQueueInfo.getBannerId())
                                .withPriority(bsResyncQueueInfo.getPriority())
                                .withSequenceTime(bsResyncQueueInfo.getSequenceTime()
                                        .format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)));
    }
}
