package ru.yandex.direct.internaltools.tools.bsresyncqueue.container;

import javax.annotation.ParametersAreNonnullByDefault;

import com.univocity.parsers.annotations.Parsed;

/**
 * Контейнер для хранения данных об объекте для добавления в очередь
 */
@ParametersAreNonnullByDefault
public class AddObjectInfo {
    public static final String CAMPAIGN_ID_FIELD_NAME = "cid";
    public static final String ADGROUP_ID_FIELD_NAME = "pid";
    public static final String BANNER_ID_FIELD_NAME = "bid";
    public static final String PRIORITY_FIELD_NAME = "priority";

    @Parsed(field = CAMPAIGN_ID_FIELD_NAME)
    private Long campaignId;

    @Parsed(field = ADGROUP_ID_FIELD_NAME)
    private Long adGroupId;

    @Parsed(field = BANNER_ID_FIELD_NAME)
    private Long bannerId;

    @Parsed(field = PRIORITY_FIELD_NAME)
    private Long priority;

    public Long getCampaignId() {
        return campaignId;
    }

    public AddObjectInfo withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public AddObjectInfo withAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public AddObjectInfo withBannerId(Long bannerId) {
        this.bannerId = bannerId;
        return this;
    }

    public Long getPriority() {
        return priority;
    }

    public AddObjectInfo withPriority(Long priority) {
        this.priority = priority;
        return this;
    }
}
