package ru.yandex.direct.internaltools.tools.bsresyncqueue.container;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Контейнер для хранения кол-во добавленных объектов для кампании
 */
@ParametersAreNonnullByDefault
public class AddedCampaignInfo {

    @JsonProperty("Кампания")
    private Long campaignId;

    @JsonProperty("Количество добавленных объектов")
    private Long addedObjectsCount;

    public AddedCampaignInfo(Long campaignId, Long addedObjectsCount) {
        this.campaignId = campaignId;
        this.addedObjectsCount = addedObjectsCount;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public AddedCampaignInfo withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Long getAddedObjectsCount() {
        return addedObjectsCount;
    }

    public AddedCampaignInfo withAddedObjectsCount(Long addedObjectsCount) {
        this.addedObjectsCount = addedObjectsCount;
        return this;
    }
}
