package ru.yandex.direct.internaltools.tools.bsresyncqueue.container;


import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang3.time.DurationFormatUtils;

import ru.yandex.direct.core.entity.bs.resync.queue.model.BsResyncPriority;
import ru.yandex.direct.core.entity.bs.resync.queue.model.BsResyncQueueStat;

import static ru.yandex.direct.internaltools.tools.bsresyncqueue.container.ResyncQueueStat.BANNERS_FIELD;
import static ru.yandex.direct.internaltools.tools.bsresyncqueue.container.ResyncQueueStat.CAMPAIGNS_FIELD;
import static ru.yandex.direct.internaltools.tools.bsresyncqueue.container.ResyncQueueStat.CONTEXTS_FIELD;
import static ru.yandex.direct.internaltools.tools.bsresyncqueue.container.ResyncQueueStat.MAX_AGE_FIELD;
import static ru.yandex.direct.internaltools.tools.bsresyncqueue.container.ResyncQueueStat.NAME_FIELD;
import static ru.yandex.direct.internaltools.tools.bsresyncqueue.container.ResyncQueueStat.PRIORITY_FIELD;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@JsonPropertyOrder({PRIORITY_FIELD, NAME_FIELD, CAMPAIGNS_FIELD, CONTEXTS_FIELD, BANNERS_FIELD, MAX_AGE_FIELD})
public class ResyncQueueStat {
    static final String PRIORITY_FIELD = "Приоритет";
    static final String NAME_FIELD = "Название";
    static final String CAMPAIGNS_FIELD = "Кампаний";
    static final String CONTEXTS_FIELD = "Условий показа";
    static final String BANNERS_FIELD = "Баннеров";
    static final String MAX_AGE_FIELD = "Максимальный возраст";

    private final BsResyncQueueStat stat;
    private String name;

    public ResyncQueueStat(BsResyncQueueStat stat) {
        this.stat = stat;
        name = ifNotNull(ifNotNull(stat.getPriority(), BsResyncPriority::tryParse), BsResyncPriority::name);
    }

    @JsonProperty(PRIORITY_FIELD)
    public Long getPriority() {
        return stat.getPriority();
    }

    @JsonProperty(NAME_FIELD)
    public String getName() {
        return name;
    }

    @JsonProperty(CAMPAIGNS_FIELD)
    public Long getCampaignsNum() {
        return stat.getCampaignsNum();
    }

    @JsonProperty(CONTEXTS_FIELD)
    public Long getContextsNum() {
        return stat.getContextsNum();
    }

    @JsonProperty(BANNERS_FIELD)
    public Long getBannersNum() {
        return stat.getBannersNum();
    }

    @JsonProperty(MAX_AGE_FIELD)
    public String getMaximumAgeString() {
        return DurationFormatUtils.formatDurationWords(stat.getMaximumAge().toMillis(), true, true);
    }

    public ResyncQueueStat withName(String name) {
        this.name = name;
        return this;
    }
}
