package ru.yandex.direct.internaltools.tools.bsresyncqueue.container;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class ViewResyncQueueInfo {

    @JsonProperty("cid")
    private Long campaignId;

    @JsonProperty("pid")
    private Long adGroupId;

    @JsonProperty("bid")
    private Long bannerId;

    @JsonProperty("priority")
    private Long priority;

    @JsonProperty("sequence_time")
    private String sequenceTime;

    public ViewResyncQueueInfo withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public ViewResyncQueueInfo withAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public ViewResyncQueueInfo withBannerId(Long bannerId) {
        this.bannerId = bannerId;
        return this;
    }

    public ViewResyncQueueInfo withPriority(Long priority) {
        this.priority = priority;
        return this;
    }

    public ViewResyncQueueInfo withSequenceTime(String sequenceTime) {
        this.sequenceTime = sequenceTime;
        return this;
    }
}
