package ru.yandex.direct.internaltools.tools.bsresyncqueue.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@ParametersAreNonnullByDefault
public class AddCampaignsToBsResyncQueueParameters extends InternalToolParameter {

    @TextArea(rows = 3, columns = 40)
    @Input(label = "Номера кампаний (cid'ы):", description = "номера кампаний должны быть отделены друг от друга запятой или любым whitespace символом")
    private String campaignIds;

    @Input(label = "Приоритет переотправки:")
    private ResyncPriority priority;

    public String getCampaignIds() {
        return campaignIds;
    }

    public AddCampaignsToBsResyncQueueParameters withCampaignIds(String campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public ResyncPriority getPriority() {
        return priority;
    }

    public AddCampaignsToBsResyncQueueParameters withPriority(
            ResyncPriority priority) {
        this.priority = priority;
        return this;
    }
}
