package ru.yandex.direct.internaltools.tools.bsresyncqueue.model;

import ru.yandex.direct.core.entity.bs.export.queue.model.QueueType;
import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class CampaignIdsAndQueueType extends InternalToolParameter {
    public static final String CAMPAIGN_IDS_FIELD_NAME = "campaignIds";

    @Input(label = "сбросить кампаниям время в очередях экспорта и ре-экспорта на текущее",
            description = "Полезно при перемещении кампаний давно находящихся в очереди - " +
                    "так не будут загораться мониторинги на возраст этой очереди")
    @CheckBox(checked = false)
    private boolean resetTime;

    @TextArea(rows = 4, columns = 40)
    @Input(label = CAMPAIGN_IDS_FIELD_NAME,
            description = "Номера кампаний (cid'ы), могут быть разделены запятыми или любым whitespace символами")
    private String campaignIds;

    @Input(required = false, label = "очередь",
            description = "(отсутствие выбранного значения соответствует стандартной очереди)")
    private QueueType queueType;

    public String getCampaignIds() {
        return campaignIds;
    }

    public CampaignIdsAndQueueType withCampaignIds(String campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public QueueType getQueueType() {
        return queueType;
    }

    public CampaignIdsAndQueueType withQueueType(QueueType queueType) {
        this.queueType = queueType;
        return this;
    }

    public boolean isResetTime() {
        return resetTime;
    }

    public CampaignIdsAndQueueType withResetTime(boolean resetTime) {
        this.resetTime = resetTime;
        return this;
    }
}
