package ru.yandex.direct.internaltools.tools.bsresyncqueue.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.core.entity.bs.resync.queue.model.BsResyncPriority;

@ParametersAreNonnullByDefault
public enum ResyncPriority {
    LAZY_RESYNC("Обычный", BsResyncPriority.INTERNAL_REPORTS_LAZY_RESYNC),
    FAST_RESYNC("Срочно нужно", BsResyncPriority.INTERNAL_REPORTS_FAST_RESYNC);

    private String description;
    private BsResyncPriority bsResyncPriority;

    ResyncPriority(String description, BsResyncPriority priority) {
        this.description = description;
        this.bsResyncPriority = priority;
    }

    @JsonValue
    public String getDescription() {
        return description;
    }

    public BsResyncPriority getBsResyncPriority() {
        return bsResyncPriority;
    }

    @Override
    public String toString() {
        return getDescription();
    }
}
