package ru.yandex.direct.internaltools.tools.business_unit;

import java.util.List;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.product.repository.ProductRepository;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Component
public class BusinessUnitsListPreprocessor implements InternalToolInputPreProcessor<String> {

    @Autowired
    private ProductRepository productRepository;

    private List<String> getBUNames() {
        var businessNames = productRepository.getBusinessUnitNames().entrySet().stream()
                .map(e -> String.join("; ", e.getKey().toString(), e.getValue()))
                .collect(Collectors.toList());

        return ImmutableList.<String>builder()
                .add("...")
                .addAll(businessNames)
                .build();
    }

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, String> preSend(
            InternalToolInput.Builder<T, String> inputBuilder) {
        List<String> buNames = getBUNames();
        return inputBuilder
                .withAllowedValues(getBUNames())
                .addValidator(inSet(ImmutableSet.<String>builder().addAll(buNames).build()));
    }


}
