package ru.yandex.direct.internaltools.tools.business_unit;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.product.model.Product;
import ru.yandex.direct.core.entity.product.model.ProductType;
import ru.yandex.direct.core.entity.product.repository.ProductRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;

@Tool(
        name = "Установить правильный бизнес-юнит у продукта",
        label = "change_product_business_unit",
        description = "Установить бизнес юнит для автоматически импортированного продукта",
        consumes = ProductsInfoValue.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.UPDATE)
@Category(InternalToolCategory.BUSINESS_UNITS)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER})
@ParametersAreNonnullByDefault
public class ChangeProductBusinessUnitTool extends MassInternalTool<ProductsInfoValue, ProductsInfo> {

    @Autowired
    private ProductRepository productRepository;


    @Autowired
    private DslContextProvider dslContextProvider;

    @Override
    protected List<ProductsInfo> getMassData(ProductsInfoValue parameter) {
        var splittedName = parameter.getName().split(";");
        var splittedBu = parameter.getUnit().split(";");

        if (splittedBu.length > 0 && splittedName.length > 0) {
            long productId = Long.parseLong(splittedName[0]);
            long buId = Long.parseLong(splittedBu[0]);

            List<Product> product = productRepository.getProductsById(List.of(productId));
            String bu = productRepository.getBusinessUnitNames().get(buId);

            if (!product.isEmpty() && bu != null) {
                productRepository.updateBusinessUnit(dslContextProvider.ppcdict(), productId, buId);
            }
        }

        return productRepository.getAllProducts()
                .stream()
                .filter(e -> e.getType() == ProductType.AUTO_IMPORT)
                .sorted(Comparator.comparing(Product::getId))
                .map(e -> new ProductsInfo(e.getProductName(), e.getBusinessUnit()))
                .collect(Collectors.toList());
    }


}
