package ru.yandex.direct.internaltools.tools.business_unit;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class ProductsInfoValue extends InternalToolParameter {
    public static final String VALUE_FIELD_NAME = "Бизнес юнит";

    @Input(label = "Название продукта", processors = {ProductsListPreprocessor.class})
    @Select(preprocessed = true, defaultValue = "...")
    private String name;

    @Input(label = VALUE_FIELD_NAME, processors = {BusinessUnitsListPreprocessor.class})
    @Select(preprocessed = true, defaultValue = "...")
    private String unit;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
}
