package ru.yandex.direct.internaltools.tools.business_unit;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.product.model.Product;
import ru.yandex.direct.core.entity.product.model.ProductType;
import ru.yandex.direct.core.entity.product.repository.ProductRepository;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.core.input.InternalToolInput;
import ru.yandex.direct.internaltools.core.input.InternalToolInputPreProcessor;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Component
public class ProductsListPreprocessor implements InternalToolInputPreProcessor<String> {

    @Autowired
    private ProductRepository productRepository;

    private List<String> getProductNames() {
        var productNames = productRepository.getAllProducts()
                .stream()
                .sorted(Comparator.comparing(Product::getId))
                .filter(e -> e.getType() == ProductType.AUTO_IMPORT)
                .map(e -> String.join("; ", e.getId().toString(), e.getProductName()))
                .collect(Collectors.toList());

        return ImmutableList.<String>builder()
                .add("...")
                .addAll(productNames)
                .build();
    }

    @Override
    public <T extends InternalToolParameter> InternalToolInput.Builder<T, String> preSend(
            InternalToolInput.Builder<T, String> inputBuilder) {
        List<String> productNames = getProductNames();

        return inputBuilder
                .withAllowedValues(getProductNames())
                .addValidator(inSet(ImmutableSet.<String>builder().addAll(productNames).build()));
    }


}
