package ru.yandex.direct.internaltools.tools.campaign;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.campaign.model.CpmCampaignAuctionPriorityParametrs;

@Tool(
        name = "Установка auctionPriority",
        label = "set_cpm_campaign_auction_priority",
        description = "Позволяет установить на cpm кампанию auction priority.",
        consumes = CpmCampaignAuctionPriorityParametrs.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.SET)
@Category(InternalToolCategory.CPM)
@AccessGroup({InternalToolAccessRole.SUPER, InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.SUPPORT})
@ParametersAreNonnullByDefault
public class CpmCampaignAuctionPriorityTool implements BaseInternalTool<CpmCampaignAuctionPriorityParametrs> {

    @Autowired
    private CampaignRepository campaignRepository;

    @Autowired
    private ShardHelper shardHelper;

    @Override
    public InternalToolResult process(CpmCampaignAuctionPriorityParametrs parametrs) {
        var shard = shardHelper.getShardByCampaignId(parametrs.getCid());
        var rowUpdated = campaignRepository.setCampaignsCpmPriceAuctionPriority(shard,
                parametrs.getCid(),
                parametrs.getPriority());
        if (rowUpdated == 1) {
            return new InternalToolResult().withMessage("Успешно");
        } else {
            return new InternalToolResult().withMessage("Ошибка");
        }
    }
}
