package ru.yandex.direct.internaltools.tools.campaign;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusnopay;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;

@Repository
@ParametersAreNonnullByDefault
public class PaymentsForLoginRepository {

    private final DslContextProvider dslContextProvider;

    @Autowired
    public PaymentsForLoginRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    public List<Long> getCidsByUidAndStatusNoPay(int shard, Long chiefUid, CampaignsStatusnopay statusNoPay) {
        return dslContextProvider.ppc(shard)
                .select(CAMPAIGNS.CID)
                .from(CAMPAIGNS)
                .where(CAMPAIGNS.UID.eq(chiefUid))
                .and(CAMPAIGNS.STATUS_NO_PAY.eq(statusNoPay))
                .fetch()
                .getValues(CAMPAIGNS.CID, Long.class);
    }

    public Integer updateStatusNoPay(int shard, List<Long> cids, CampaignsStatusnopay statusNoPay) {
        return dslContextProvider.ppc(shard)
                .update(CAMPAIGNS)
                .set(CAMPAIGNS.STATUS_NO_PAY, statusNoPay)
                .where(CAMPAIGNS.CID.in(cids))
                .execute();
    }
}
