package ru.yandex.direct.internaltools.tools.campaign;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusnopay;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

@Service
@ParametersAreNonnullByDefault
public class PaymentsForLoginService {
    private final ShardHelper shardHelper;
    private final PaymentsForLoginRepository paymentsForLoginRepository;

    @Autowired
    public PaymentsForLoginService(ShardHelper shardHelper, PaymentsForLoginRepository paymentsForLoginRepository) {
        this.shardHelper = shardHelper;
        this.paymentsForLoginRepository = paymentsForLoginRepository;
    }

    public List<Long> getCidsByUidAndStatusNoPay(Long chiefUid, CampaignsStatusnopay statusNoPay) {
        int shard = shardHelper.getShardByClientUid(chiefUid);
        return paymentsForLoginRepository.getCidsByUidAndStatusNoPay(shard, chiefUid, statusNoPay);
    }

    public Integer updateStatusNoPay(Long chiefUid, List<Long> cids, CampaignsStatusnopay statusNoPay) {
        int shard = shardHelper.getShardByClientUid(chiefUid);
        return paymentsForLoginRepository.updateStatusNoPay(shard, cids, statusNoPay);
    }

}
