package ru.yandex.direct.internaltools.tools.campaign.container;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.campaign.model.ContentLanguage;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

public class SmartCampaignLanguageParameters extends InternalToolParameter {

    @Input(label = "Операция")
    private SmartCampaignLanguageOperationName operationName;

    @Input(label = "Список id кампаний")
    @TextArea
    private String cids;

    @Input(label = "Выставить выбранный язык")
    @JsonProperty("language")
    private ContentLanguage language;

    public String getCids() {
        return cids;
    }

    public void setCids(String cids) {
        this.cids = cids;
    }

    public SmartCampaignLanguageOperationName getOperationName() {
        return operationName;
    }

    public void setOperationName(SmartCampaignLanguageOperationName operationName) {
        this.operationName = operationName;
    }

    public ContentLanguage getLanguage() {
        return language;
    }

    public void setLanguage(ContentLanguage language) {
        this.language = language;
    }
}
