package ru.yandex.direct.internaltools.tools.campaign.container;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Контейнер для хранения информации о том, когда на кампании были деньги
 */
@ParametersAreNonnullByDefault
public class WhenMoneyOnCampaignWasInfo {

    @JsonProperty("Кампания")
    private Long campaignId;

    @JsonProperty("Начало денежного периода")
    private LocalDateTime intervalStart;

    @JsonProperty("Окончание денежного периода")
    private LocalDateTime intervalEnd;

    public Long getCampaignId() {
        return campaignId;
    }

    public WhenMoneyOnCampaignWasInfo withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public LocalDateTime getIntervalStart() {
        return intervalStart;
    }

    public WhenMoneyOnCampaignWasInfo withIntervalStart(LocalDateTime intervalStart) {
        this.intervalStart = intervalStart;
        return this;
    }

    public LocalDateTime getIntervalEnd() {
        return intervalEnd;
    }

    public WhenMoneyOnCampaignWasInfo withIntervalEnd(LocalDateTime intervalEnd) {
        this.intervalEnd = intervalEnd;
        return this;
    }
}
