package ru.yandex.direct.internaltools.tools.campaign.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.direct.internaltools.core.annotations.input.CheckBox;
import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;

@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNonnullByDefault
public class PaymentsForLoginParameters extends InternalToolParameter {

    @TextArea
    @Input(label = "Список логинов", description = "Логины должны быть отделены друг от друга запятой или любым whitespace символом")
    private String logins;

    @CheckBox(checked = false)
    @Input(label = "Разрешить оплату")
    private Boolean isPaymentAllowed;

    public String getLogins() {
        return logins;
    }

    public Boolean getIsPaymentAllowed() {
        return isPaymentAllowed;
    }
}
