package ru.yandex.direct.internaltools.tools.canvas;


import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.canvas.tools_client.CanvasToolsClient;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.canvas.model.GetCreativeByIdParameter;
import ru.yandex.direct.internaltools.tools.canvas.model.VastDataResponse;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;


@Tool(
        name = "Получить VAST из Канваса",
        label = "canvas_get_vast_operation",
        description = "Выводит VAST из базы Канваса",
        consumes = GetCreativeByIdParameter.class,
        type = InternalToolType.REPORT
)
@Action(InternalToolAction.SHOW)
@Category(InternalToolCategory.CANVAS)
@AccessGroup({InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.SUPER})
@ParametersAreNonnullByDefault
public class GetVastByIdTool extends MassInternalTool<GetCreativeByIdParameter,
        VastDataResponse> {
    @Autowired
    CanvasToolsClient canvasToolsClient;

    @Override
    public ValidationResult<GetCreativeByIdParameter, Defect> validate(
            GetCreativeByIdParameter updateVastByIdParameter) {

        ItemValidationBuilder<GetCreativeByIdParameter, Defect> validationBuilder =
                ItemValidationBuilder.of(updateVastByIdParameter);

        validationBuilder
                .item(updateVastByIdParameter.getCreativeId(), "creativeId")
                .check(Constraint.fromPredicate(id -> id > 0, CommonDefects.validId()));
        return validationBuilder.getResult();
    }

    @Override
    protected List<VastDataResponse> getMassData(GetCreativeByIdParameter parameter) {
        Long creativeId = parameter.getCreativeId();
        String creativeData = canvasToolsClient.getVideoVast(creativeId);

        return Collections.singletonList(new VastDataResponse(creativeId, creativeData));
    }

}
