package ru.yandex.direct.internaltools.tools.canvas;


import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.canvas.tools_client.CanvasToolsClient;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.core.implementations.MassInternalTool;
import ru.yandex.direct.internaltools.tools.canvas.model.VideoConvertParameter;
import ru.yandex.direct.internaltools.tools.canvas.model.VideoDataResponse;
import ru.yandex.direct.internaltools.utils.ToolParameterUtils;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Tool(
        name = "Переконвертировать видео",
        label = "canvas_reconvert_video",
        description = "Запускает переконвертацию видео в сэндбоксе",
        consumes = VideoConvertParameter.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.UPDATE)
@Category(InternalToolCategory.CANVAS)
@AccessGroup({InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.SUPER})
@ParametersAreNonnullByDefault
public class ReconvertVideoTool extends MassInternalTool<VideoConvertParameter, VideoDataResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ReconvertVideoTool.class);

    @Autowired
    private CanvasToolsClient canvasToolsClient;
    @Override
    public ValidationResult<VideoConvertParameter, Defect> validate(
            VideoConvertParameter getCreativeByIdParameter) {
        ItemValidationBuilder<VideoConvertParameter, Defect> validationBuilder =
                ItemValidationBuilder.of(getCreativeByIdParameter);
        return validationBuilder.getResult();
    }

    @Override
    protected List<VideoDataResponse> getMassData(VideoConvertParameter parameter) {
        String videosToConvert = parameter.getVideoIds();
        Set<String> videos = ToolParameterUtils.parseVideoFilesString(videosToConvert);
        List<VideoDataResponse> dataResponses = new ArrayList<>();
        for (String video : videos) {
            String taskId = canvasToolsClient.regenerateVideo(video);
            logger.info(video + " " + taskId);
            VideoDataResponse dataResponse = new VideoDataResponse(video, taskId);
            dataResponses.add(dataResponse);
        }

        return dataResponses;
    }

}
