package ru.yandex.direct.internaltools.tools.canvas;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.canvas.tools_client.CanvasToolsClient;
import ru.yandex.direct.internaltools.core.BaseInternalTool;
import ru.yandex.direct.internaltools.core.annotations.tool.AccessGroup;
import ru.yandex.direct.internaltools.core.annotations.tool.Action;
import ru.yandex.direct.internaltools.core.annotations.tool.Category;
import ru.yandex.direct.internaltools.core.annotations.tool.Tool;
import ru.yandex.direct.internaltools.core.container.InternalToolResult;
import ru.yandex.direct.internaltools.core.enums.InternalToolAccessRole;
import ru.yandex.direct.internaltools.core.enums.InternalToolAction;
import ru.yandex.direct.internaltools.core.enums.InternalToolCategory;
import ru.yandex.direct.internaltools.core.enums.InternalToolType;
import ru.yandex.direct.internaltools.tools.canvas.model.VideoConstructorOperationParameter;
import ru.yandex.direct.internaltools.utils.ToolParameterUtils;

@Tool(
        name = "Операции над файлами Видеоконструктора",
        label = "canvas_videoconstructor_operations",
        description = "Запускает операцию в Видеоконструкторе по списку Id файлов",
        consumes = VideoConstructorOperationParameter.class,
        type = InternalToolType.WRITER
)
@Action(InternalToolAction.UPDATE)
@Category(InternalToolCategory.CANVAS)
@AccessGroup({InternalToolAccessRole.DEVELOPER, InternalToolAccessRole.SUPER})
@ParametersAreNonnullByDefault
public class VideoConstructorOperationsTool implements BaseInternalTool<VideoConstructorOperationParameter> {
    @Autowired
    CanvasToolsClient canvasToolsClient;

    @Override
    public InternalToolResult process(VideoConstructorOperationParameter parameter) {
        Set<String> fileIds = ToolParameterUtils.parseVideoFilesString(parameter.getFileIds());
        switch (parameter.getOperationName()) {
            case REBUILD_PACKSHOT:
                return new InternalToolResult()
                        .withMessage("Sandbox task id: " + canvasToolsClient.rebuildPackshotVideoConstructor(fileIds));
            case REBUILD_PREVIEW:
                return new InternalToolResult()
                        .withMessage("Sandbox task id: " + canvasToolsClient.rebuildPreviewVideoConstructor(fileIds));
            default:
                throw new IllegalStateException("Unexpected enum value: " + parameter.getOperationName() + " that " +
                        "has no handler");
        }
    }
}
