package ru.yandex.direct.internaltools.tools.canvas.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.internaltools.core.annotations.input.Input;
import ru.yandex.direct.internaltools.core.annotations.input.Select;
import ru.yandex.direct.internaltools.core.annotations.input.TextArea;
import ru.yandex.direct.internaltools.core.container.InternalToolParameter;
import ru.yandex.direct.internaltools.tools.canvas.AdminRejectCreativesTool.BlockReasonPreprocessor;

@ParametersAreNonnullByDefault
public class AdminRejectCreativesParameter extends InternalToolParameter {
    @Input(label = "Список Id креативов")
    @TextArea
    String creativeIds;

    @Input(label = "Причина блокировки", processors = BlockReasonPreprocessor.class)
    @Select(preprocessed = true)
    String blockReason;

    public String getCreativeIds() {
        return creativeIds;
    }

    public void setCreativeIds(String creativeIds) {
        this.creativeIds = creativeIds;
    }

    public String getBlockReason() {
        return blockReason;
    }

    public void setBlockReason(String blockReason) {
        this.blockReason = blockReason;
    }

    @Override
    public String toString() {
        return "AdminRejectCreativesParameter{" +
                "creativeIds='" + creativeIds + '\'' +
                ", blockReason='" + blockReason + '\'' +
                '}';
    }
}
