package ru.yandex.direct.internaltools.tools.canvas.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.internaltools.core.annotations.output.Enrich;
import ru.yandex.direct.internaltools.core.enums.InternalToolDetailKey;

public class CreativeDataResponse {
    @JsonProperty("Id креатива")
    private Long creativeId;

    @JsonProperty("Данные креатива в БД")
    @Enrich(InternalToolDetailKey.JSON_PRETTIFY)
    private String data;

    public CreativeDataResponse(Long creativeId, String data) {
        this.creativeId = creativeId;
        this.data = data;
    }

    public Long getCreativeId() {
        return creativeId;
    }

    public String getData() {
        return data;
    }
}
